﻿// SD: Maybe should remove the "No player installed" once something is in the list;

import mx.controls.TextInput;
import mx.controls.Button;
import mx.controls.ComboBox;
import mx.utils.Delegate;
import gfx.launchpanel.data.Profile;
import gfx.launchpanel.views.BaseDialog;
import gfx.launchpanel.data.Player;

class gfx.launchpanel.views.EditDialog extends BaseDialog {
	
	// Constants:	
	public static var CLASS_REF = gfx.launchpanel.views.EditDialog;
	public static var LINKAGE_ID:String = "EditDialog";
	
	private var nameInput:TextInput;
	private var cmdInput:TextInput;
	private var playerList:ComboBox;
	private var addPlayerBtn:Button;
	private var removePlayerBtn:Button;
	private var LP_BTN_OK:Button;
	private var LP_BTN_CANCEL:Button;
	public var LP_LBL_PLAYER:TextField;
	public var LP_LBL_PROFILE_NAME:TextField;
	public var LP_LBL_COMMAND_PARAS:TextField;
	private var selectedProfile:Object;
	
	public function ProfileDialog() {
		super();
	}
	
	public function loadPlayers(p_playersList:Array):Void {
		playerList.dataProvider = p_playersList;
		
	}
	
	public function loadProfile(p_selectedProfile:Object,p_labels:Object):Void {
		LP_BTN_CANCEL.label = p_labels['LP_BTN_CANCEL'];
		LP_BTN_OK.label = p_labels['LP_BTN_OK'];
		LP_LBL_PLAYER.text = p_labels['LP_LBL_PLAYER'];
		LP_LBL_PROFILE_NAME.text = p_labels['LP_LBL_PROFILE_NAME'];
		LP_LBL_COMMAND_PARAS.text = p_labels['LP_LBL_COMMAND_PARAS'];
		selectedProfile = p_selectedProfile;
		nameInput.text = selectedProfile.name;
		cmdInput.text = selectedProfile.command || '' ;
		var playerName = selectedProfile.playerName;
		var l:Number = playerList.length;
		if (nameInput.text.length > 0) { LP_BTN_OK.enabled = true; }
		if (playerList.length == 0 ) { LP_BTN_OK.enabled = false; }
		removePlayerBtn.enabled = (playerList.length >= 1);
		for(var i:Number=0;i<l;i++) {
			if (playerList.getItemAt(i).path == selectedProfile.playerPath && playerList.getItemAt(i).name == selectedProfile.playerName) {
				playerList.selectedIndex = i;
			}
		};
		//updateDialog();
	}
	
	public function update():Void {
		playerList.selectedIndex = playerList.length-1;
		updateDialog();
	}
	
	private function configUI():Void {
		super.configUI();
		playerList.labelField = "name";
		playerList.rowCount = 4;
		
		LP_BTN_OK.enabled = false;
		LP_BTN_OK.addEventListener("click", Delegate.create(this, saveProfile));
		LP_BTN_CANCEL.addEventListener("click", Delegate.create(this, close));
		addPlayerBtn.addEventListener("click", Delegate.create(this, onAddPlayer));
		removePlayerBtn.addEventListener("click", Delegate.create(this, onRemovePlayer));
		playerList.addEventListener("change", Delegate.create(this, onPlayerChange));
		nameInput.addEventListener("change", Delegate.create(this, onProfileChange));
	}
	
	private function onProfileChange(eventObj:Object):Void {
		if (nameInput.text.length < 1) {
			LP_BTN_OK.enabled = false;
		}else {
			LP_BTN_OK.enabled = true;
		}
	}
	
	private function onPlayerChange(eventObj:Object):Void {
		
		//updateDialog();
	}
	
	private function updateDialog():Void {
		
		if (playerList.getItemAt(0).name == '[-- No Players Installed --]') { 
			playerList.removeItemAt(0);
		}else {
			//MMExecute('fl.trace("'+playerList.length+'");');
			playerList.addItemAt(new Player('[-- No Players Installed --]',''),0);
		}
		removePlayerBtn.enabled = (playerList.getItemAt(0).name == '[-- No Players Installed --]' || playerList.getItemAt(0).name == undefined ) ? false : true;
		LP_BTN_OK.enabled = (playerList.length <=0 || playerList.getItemAt(0).name == '[-- No Players Installed --]' ) ? false : true;
		if (playerList.length == 0 ) { LP_BTN_OK.enabled = false; }
	}
	
	private function onRemovePlayer(p_event:Object):Void {
		dispatchEvent({type:"removePlayer",removedPlayer:playerList.selectedIndex});
		updateDialog();
	}
	
	private function onAddPlayer(p_event:Object):Void {
		dispatchEvent({type:"addPlayer"});
		updateDialog();
	}
	
	private function saveProfile(p_event:Object):Void {
		var selectedPlayer:Object = {};
		if (playerList.selectedItem == undefined) { 
			selectedPlayer = playerList.getItemAt(playerList.length-1); 
		}else {
			selectedPlayer = playerList.selectedItem;
		}
		
		var profile = new Profile(nameInput.text,cmdInput.text,selectedPlayer.path,selectedPlayer.name);
		dispatchEvent({type:"edit",profile:profile});
	}
	
}